/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.util.ArrayList;
import java.util.List;
import journeymap.api.v2.client.ui.component.LayeredScreen;
import journeymap.client.JourneymapClient;
import journeymap.client.event.handlers.KeybindingHandler;
import journeymap.client.log.JMLogger;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.option.ClientOptionsManager;
import journeymap.client.ui.option.MinimapOptions;
import journeymap.client.ui.option.OptionScreen;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_437;

public class ScreenEventHandler {
    static final List<String> BLACK_LISTED_SCREENS = new ArrayList<String>();
    boolean clicked = false;
    boolean didDrag = false;
    static ScreenEventHandler instance;

    private ScreenEventHandler() {
    }

    public static ScreenEventHandler getInstance() {
        if (instance == null) {
            instance = new ScreenEventHandler();
        }
        return instance;
    }

    public void onScreenPreRender(class_437 screen, class_332 graphics, int mouseX, int mouseY) {
        if (JourneymapClient.getInstance() != null && JourneymapClient.getInstance().getCoreProperties() != null && JourneymapClient.getInstance().enabled() && JourneymapClient.getInstance().getCoreProperties().allowMiniMapBehindScreens.get().booleanValue()) {
            try {
                boolean preview;
                boolean bl = preview = screen instanceof ClientOptionsManager && ((ClientOptionsManager)screen).previewMiniMap();
                if (this.allowableDrawScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue() && UIManager.INSTANCE.isMiniMapEnabled()) {
                    MiniMap miniMap = UIManager.INSTANCE.getMiniMap();
                    miniMap.drawMap(graphics, true);
                } else if (!preview) {
                    this.clicked = false;
                }
            }
            catch (Throwable t) {
                JMLogger.throwLogOnce("Unexpected error during onScreenPreRender: " + String.valueOf(t), t);
            }
        }
    }

    public boolean onScreenMousePressedEvent(class_437 screen, class_11909 event) {
        if (JourneymapClient.getInstance().enabled() && !this.clicked && this.allowableDragScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue()) {
            this.clicked = UIManager.INSTANCE.getMiniMap().mouseClicked(event, false);
            return this.clicked;
        }
        return KeybindingHandler.getInstance().consume(screen, (class_11907)event);
    }

    public boolean onScreenMouseDraggedEvent(class_437 screen, class_11909 event, double dragX, double dragY) {
        if (JourneymapClient.getInstance().enabled() && this.clicked && this.allowableDragScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue()) {
            this.didDrag = UIManager.INSTANCE.getMiniMap().mouseDragged(event, dragX, dragY);
            return this.didDrag;
        }
        return false;
    }

    public boolean onScreenMouseReleasedEvent(class_437 screen, class_11909 event) {
        if (JourneymapClient.getInstance().enabled() && UIManager.INSTANCE.getMiniMap() != null && UIManager.INSTANCE.getMiniMap().mouseReleased(event)) {
            this.clicked = false;
            return true;
        }
        return false;
    }

    public void onScreenClosedEvent(class_437 screen) {
        if (JourneymapClient.getInstance().enabled() && JourneymapClient.getInstance().isMapping().booleanValue() && UIManager.INSTANCE.getMiniMap() != null) {
            UIManager.INSTANCE.getMiniMap().mouseReleased(new class_11909(0.0, 0.0, new class_11910(0, 0)));
            this.clicked = false;
            this.didDrag = false;
        }
    }

    private boolean allowableDragScreens(class_437 screen) {
        return screen instanceof ClientOptionsManager;
    }

    private boolean allowableDrawScreens(class_437 screen) {
        if (screen instanceof LayeredScreen) {
            LayeredScreen layeredScreen = (LayeredScreen)screen;
            return this.allowableDrawScreens(layeredScreen.getBackgroundScreen());
        }
        return !(screen instanceof Fullscreen) && !(screen instanceof MinimapOptions) && !(screen instanceof OptionScreen) && !(screen instanceof class_408) && !this.modScreens(screen);
    }

    private boolean modScreens(class_437 screen) {
        return screen != null && (BLACK_LISTED_SCREENS.contains(screen.getClass().getSimpleName()) || BLACK_LISTED_SCREENS.contains(screen.getClass().getName()));
    }

    static {
        BLACK_LISTED_SCREENS.add("com.cobblemon.mod.common.client.gui.battle.BattleGUI");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.TitleScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.worldselection.SelectWorldScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.LevelLoadingScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.GenericMessageScreen");
    }
}

